using System;
using System.Collections.Generic;
using System.Linq;

class Program
{
    static void Main()
    {

        int N = int.Parse(Console.ReadLine());

        List<int>[] edges = new List<int>[N + 1];
        for (int i = 1; i <= N; i++)
        {
            edges[i] = new List<int>();
        }

        for (int i = 1; i <= N - 1; i++)
        {
            int[] uv = Console.ReadLine().Split().Select(int.Parse).ToArray();
            edges[uv[0]].Add(uv[1]);
            edges[uv[1]].Add(uv[0]);
        }

        int[] platforms = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int[] changes = Console.ReadLine().Split().Select(int.Parse).ToArray();

        int[] skok = new int[N + 1];

        Solve(N, edges, platforms, changes, skok);

        Console.WriteLine(string.Join(" ", skok.Skip(1)));
    }

    static void Solve(int N, List<int>[] edges, int[] platforms, int[] changes, int[] skok)
    {
        Queue<int> queue = new Queue<int>();
        HashSet<int> visited = new HashSet<int>();


        for (int i = 1; i <= N; i++)
        {
            if (platforms[i] == 1)
            {
                queue.Enqueue(i);
                visited.Add(i);
            }
        }

        while (queue.Count >= 1)
        {
            int currentRoom = queue.Dequeue();
            skok[currentRoom] = changes[currentRoom - 1];

            foreach (int neighbor in edges[currentRoom])
            {
                if (!visited.Contains(neighbor))
                {
                    queue.Enqueue(neighbor);
                    visited.Add(neighbor);
                }
            }
        }

        for (int i = 1; i <= N; i++)
        {
            int currentRoom = i;
            int minSkok = int.MaxValue;

            foreach (int neighbor in edges[currentRoom])
            {
                if (skok[neighbor] < minSkok)
                {
                    minSkok = skok[neighbor];
                }
            }

            if (minSkok == int.MaxValue)
            {
                skok[i] = -1;
            }
            else
            {
                skok[i] += minSkok;
            }
        }
    }
}